package ie.ucd.sixth.adaptor.wasp;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.TooManyListenersException;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;

public class SerialProgram {

	public SerialProgram(CommPortIdentifier portId, int baudRate, WaspmoteAdaptor adaptor) {
		DataInputStream is;
		SerialPort serialPort = null;
		
		// open the serial port
		try {
			serialPort = (SerialPort) portId.open("Artificial Horizont", 2000);
		} catch (PortInUseException ex) {
			System.err.println("Port already in use!");
		}

		// Get input stream
		try {
			is = new DataInputStream(serialPort.getInputStream());
			adaptor.setSerialReader(is);
		} catch (IOException e) {
			System.err.println("Cannot open Input Stream " + e);
			is = null;
		}

		try {
			serialPort.setSerialPortParams(baudRate, SerialPort.DATABITS_8,
					SerialPort.STOPBITS_1, SerialPort.PARITY_NONE);
		} catch (UnsupportedCommOperationException ex) {
			System.err.println("Wrong settings for the serial port: "
					+ ex.getMessage());
		}

		try {
			serialPort.setFlowControlMode(SerialPort.FLOWCONTROL_NONE);
		} catch (UnsupportedCommOperationException ex) {
			System.err.println("Check the flow control setting: "
					+ ex.getMessage());
		}

		// Add an event Listener
		try {
			serialPort.addEventListener(adaptor);
		} catch (TooManyListenersException ev) {
			System.err.println("Too many Listeners! " + ev);
		}

		// Advise if data available to be read on the port
		serialPort.notifyOnDataAvailable(true);

	}

}
